/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.FSPCmdMgr;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt64;
import org.snia.wbem.cim.UnsignedInt8;

public class FspProcPoolUtilization {
    private static final String GET_PROC_POOL_UTILIZATION = "GET_PROC_POOL_UTILIZATION";
    private static final String CYCLE_PER_SND = "CYCLE_PER_SND";
    private static final String TOT_SIZE_IN_PROC_UNIT = "TOT_SIZE_IN_PROC_UNIT";
    private static final String CFG_SIZE_IN_PROC_UNIT = "CFG_SIZE_IN_PROC_UNIT";
    private static final String TOT_CYCLES = "TOT_CYCLES";
    private static final String UTILIZED_CYCLES = "UTILIZED_CYCLES";
    private static final String CUR_CYCLES = "CUR_CYCLES";
    private UnsignedInt32 mCyclesPerSecond;
    private UnsignedInt32 mTotalSizeInProcUnit;
    private UnsignedInt32 mCfgSizeInProcUnit;
    private UnsignedInt64 mTotalCycles;
    private UnsignedInt64 mUtilizedCycles;
    private UnsignedInt64 mCurrentCycles;

    FspProcPoolUtilization() {
    }

    FspProcPoolUtilization getProcessorPoolUtilizationCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt8 unsignedInt8) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_PROC_POOL_UTILIZATION, new String[]{unsignedInt8.toString()});
        this.mCyclesPerSecond = (UnsignedInt32)hashtable.get(CYCLE_PER_SND);
        this.mTotalSizeInProcUnit = (UnsignedInt32)hashtable.get(TOT_SIZE_IN_PROC_UNIT);
        this.mCfgSizeInProcUnit = (UnsignedInt32)hashtable.get(CFG_SIZE_IN_PROC_UNIT);
        this.mTotalCycles = (UnsignedInt64)hashtable.get(TOT_CYCLES);
        this.mUtilizedCycles = (UnsignedInt64)hashtable.get(UTILIZED_CYCLES);
        this.mCurrentCycles = (UnsignedInt64)hashtable.get(CUR_CYCLES);
        return this;
    }

    public UnsignedInt32 getCyclesPerSecond() {
        return this.mCyclesPerSecond;
    }

    public UnsignedInt32 getTotalSizeInProcUnit() {
        return this.mTotalSizeInProcUnit;
    }

    public UnsignedInt32 getConfigedSizeInProcUnit() {
        return this.mCfgSizeInProcUnit;
    }

    public UnsignedInt64 getTotalCycles() {
        return this.mTotalCycles;
    }

    public UnsignedInt64 getUtilizedCycles() {
        return this.mUtilizedCycles;
    }

    public UnsignedInt64 getCurrentCycles() {
        return this.mCurrentCycles;
    }
}

